import { FlatList, TouchableOpacity, Image, Pressable } from "react-native";
import React from "react";
import PhotoGalleryStyle from "./CustomPhotoGallery.style";

const RenderFooter = ({ images, image, setUpdateIndex }) => {
    const photoGalleryStyle = PhotoGalleryStyle();
    return (
            <Pressable style={[photoGalleryStyle.cont]}>
                <FlatList
                    data={images}
                    renderItem={({ item, index }) => (
                        <TouchableOpacity
                            onPress={() => {
                                setUpdateIndex(index);
                            }}
                            activeOpacity={1}
                        >
                            {item?.url && <Image
                                source={{ uri: item?.url }}
                                style={photoGalleryStyle.footerImage(image, index)}
                            />}
                        </TouchableOpacity>
                    )}
                    keyExtractor={(_, i) => `ig${i.toString()}`}
                    horizontal
                    showsHorizontalScrollIndicator={false}
                    scrollEnabled={true}
                />
            </Pressable>
    );
};

export default RenderFooter;
